/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm8260.DeviceView.Builder;
import ibm.nways.jdm8260.DeviceView.GrayableLike;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8260.DeviceView.Network;
import ibm.nways.jdm8260.DeviceView.NetworkLike;
import ibm.nways.jdm8260.DeviceView.NetworkSet;
import ibm.nways.jdm8260.DeviceView.NetworkSetLike;
import ibm.nways.jdm8260.DeviceView.NetworksWindowLike;
import java.awt.Button;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class NetworksWindow
implements NetworksWindowLike,
ActionListener {
    private static final String[][] setsOfNetworks = new String[][]{{"Ethernet", "gif/net.ethicon.gif"}, {"TR8250", "gif/net.tricon.gif"}, {"TR8260", "gif/net.tricon.gif"}, {"FDDI", "gif/net.fddicon.gif"}, {"ATM", "gif/net.atmicon.gif"}, {"Other", "gif/net.allOthicon.gif"}};
    private static final String NETWORKS_WINDOW_GIF = "gif/net.sel_8250.gif";
    private Vector listOfNetworks;
    protected Point location;
    protected GraphicContainer graphicContainer;
    protected Button showAllButton;
    private Vector components = new Vector();
    private String showAllString;
    protected HubInfoLike hub;

    public NetworksWindow() {
        this.listOfNetworks = new Vector();
        this.showAllString = ResourceBundle.getBundle("ibm.nways.jdm8260.DeviceView.GraphicResources").getString("Show_All");
    }

    public void dispose() {
        this.showAllButton = null;
        if (this.listOfNetworks != null) {
            this.listOfNetworks.removeAllElements();
            this.listOfNetworks = null;
        }
        this.location = null;
        this.graphicContainer = null;
        this.hub = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public void addObjectToNetwork(int n, GrayableLike grayableLike) {
        NetworkLike networkLike = this.searchNetwork(n);
        if (networkLike == null) {
            networkLike = new Network(NetworkSet.getTypeOfNetwork(n));
            this.listOfNetworks.addElement(networkLike);
        }
        networkLike.addObjectToNetwork(grayableLike);
    }

    public void removeObjectFromNetwork(int n, GrayableLike grayableLike) {
        NetworkLike networkLike = this.searchNetwork(n);
        networkLike.removeObjectFromNetwork(grayableLike);
        if (networkLike.isEmpty()) {
            this.listOfNetworks.removeElement(networkLike);
        }
    }

    public NetworkLike searchNetwork(int n) {
        NetworkLike networkLike = null;
        String string = NetworkSet.getTypeOfNetwork(n);
        Enumeration enumeration = this.listOfNetworks.elements();
        while (enumeration.hasMoreElements()) {
            NetworkLike networkLike2 = (NetworkLike)enumeration.nextElement();
            if (!networkLike2.getNetwork().equals(string)) continue;
            networkLike = networkLike2;
            break;
        }
        return networkLike;
    }

    public NetworkLike searchNetwork(String string) {
        NetworkLike networkLike = null;
        Enumeration enumeration = this.listOfNetworks.elements();
        while (enumeration.hasMoreElements()) {
            NetworkLike networkLike2 = (NetworkLike)enumeration.nextElement();
            if (!networkLike2.getNetwork().equals(string)) continue;
            networkLike = networkLike2;
            break;
        }
        return networkLike;
    }

    public final void setCommonInformation(HubInfoLike hubInfoLike, Point point, GraphicContainer graphicContainer) {
        this.hub = hubInfoLike;
        this.location = point;
        this.graphicContainer = graphicContainer;
    }

    public void draw() {
        GraphicImage graphicImage = new GraphicImage(this.hub.getBrowser().imageFrom((Object)this, NETWORKS_WINDOW_GIF), this.location, 3, null, null);
        graphicImage.setFlyOver(new GraphicFlyOver(this.hub.getBundle().getString("Networks")));
        this.graphicContainer.add((GraphicComponent)graphicImage);
        this.showAllButton = new Button(this.showAllString);
        this.showAllButton.setForeground(Color.black);
        this.showAllButton.setBackground(Color.lightGray);
        this.showAllButton.setLocation(this.location.x + 6, this.location.y + 5);
        this.showAllButton.addActionListener(this);
        this.graphicContainer.add(this.showAllButton);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            leafCompositeLike.draw();
        }
    }

    public void discoverChildren() {
        int n = this.location.x + 6;
        int n2 = this.location.y + 30;
        try {
            int n3 = 0;
            while (true) {
                NetworkSetLike networkSetLike = Builder.getInstance().buildNetworkSet(this.hub, new Point(n, n2), this.graphicContainer, setsOfNetworks[n3][0], setsOfNetworks[n3][1]);
                this.add(networkSetLike);
                n2 += 24;
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public void highlightNetwork(String string) {
        NetworkLike networkLike = this.searchNetwork(string);
        Enumeration enumeration = this.listOfNetworks.elements();
        while (enumeration.hasMoreElements()) {
            NetworkLike networkLike2 = (NetworkLike)enumeration.nextElement();
            if (networkLike2 != networkLike) {
                networkLike2.gray();
                continue;
            }
            networkLike2.highlight();
        }
    }

    public void highlightAllNetworks() {
        Enumeration enumeration = this.listOfNetworks.elements();
        while (enumeration.hasMoreElements()) {
            ((NetworkLike)enumeration.nextElement()).highlight();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.highlightAllNetworks();
    }

    public boolean showNetwork(String string) {
        if (string.equals(this.showAllString)) {
            this.highlightAllNetworks();
            return true;
        }
        if (NetworkSet.isNetworkType(string)) {
            this.highlightNetwork(string);
            return true;
        }
        return false;
    }
}

